<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method payWayByParams(array $params)
 * @method getMostNearestStoreByParams(array $params)
 * @method hasProductStoresByParams(array $params)
 * @method getStoreinfoByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店绑定的支付类型
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function payWay (int $store_id) {
        return self::getClass()->payWay([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取距离最近的门店
     *
     * @param  array $location 地理位置,[125,30] [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMostNearestStore (array $location, string $brand) {
        return self::getClass()->getMostNearestStore([
            "location" => $location,
            "brand" => $brand,
        ]);
    }

    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     *
     * @support  int $node_id 产品id或者Category id [Original type uint] [ require true ]
     * @support  string $type 查询类型 [ require true ]
     * @support  int $city_id 城市id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hasProductStores () {
        return self::getClass()->hasProductStores();
    }

    /**
     * 获取某个门店的详情
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreinfo () {
        return self::getClass()->getStoreinfo();
    }

    /**
     * 根据城市id获取门店列表 
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @support  array $storeType 门店类型 [ require true ]
     * @support  string $type 获取数据基本类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreListByCityId () {
        return self::getClass()->getStoreListByCityId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}