<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method infoByParams(array $params)
 * @method offlineByParams(array $params)
 * @method listByParams(array $params)
 */
class MemberActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动创建
     *
     * @support  string $title 活动标题 [ require true ]
     * @support  string $type 活动类型 [ require true ]
     * @support  int $sort 排序 [Original type uint] [ require true ]
     * @support  int $points 积分值 [Original type uint] [ require true ]
     * @support  array $extend 扩展 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 活动更新
     *
     * @support  int $id 活动ID [Original type uint] [ require true ]
     * @support  string $title 活动标题 
     * @support  int $sort 活动排序 [Original type uint] 
     * @support  int $points 积分值 [Original type uint] 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 活动详情
     *
     * @support  int $id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 活动下线
     *
     * @support  int $id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function offline () {
        return self::getClass()->offline();
    }

    /**
     * 活动查询
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关 
     * @support  string $title 活动标题 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MemberActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MemberActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}