<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 */
class StoreGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建门店组
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $rule 规则 [ require true ]
     * @param  array $whitelist 白名单 [ require true ]
     * @param  array $blacklist 黑名单 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->create([
            "name" => $name,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 修改门店组
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $rule 规则 [ require true ]
     * @param  array $whitelist 白名单 [ require true ]
     * @param  array $blacklist 黑名单 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 门店组列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除门店组
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部门店组信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\StoreGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\StoreGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}