<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getAllProductByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method serviceGroupsByParams(array $params)
 * @method serviceLabelsByParams(array $params)
 * @method addServiceGroupByParams(array $params)
 * @method editServiceGroupByParams(array $params)
 * @method addServiceLabelByParams(array $params)
 * @method productDiscountCalcByParams(array $params)
 * @method editExtendByParams(array $params)
 * @method editCHiddenByParams(array $params)
 * @method getProductTreeByModulesByParams(array $params)
 * @method getCronUpDownTimeByParams(array $params)
 * @method setCronUpDownTimeByParams(array $params)
 * @method cronUpDownProductByParams(array $params)
 * @method addStoreToBlacklistByParams(array $params)
 * @method getProductBlacklistsByParams(array $params)
 * @method setAppointmentDeadlineByParams(array $params)
 * @method dragProductByParams(array $params)
 * @method getProductsOccupyByParams(array $params)
 * @method copyProductByParams(array $params)
 * @method deleteProductServiceGroupByParams(array $params)
 * @method clearCacheByParams(array $params)
 * @method editRecommendProductByParams(array $params)
 * @method getRecommendProductByParams(array $params)
 * @method getServiceByIdsByParams(array $params)
 * @method getGonggeAliasByParams(array $params)
 * @method christmasActivitySettingByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $module 模块 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  int $occupy_value 占点设置 
     * @support  bool $is_entity 是否为实物 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  array $extend 拓展信息 
     * @support  int $photographic_num 上传照片张数 
     * @support  int $photo_num 照片张数 
     * @support  array $blacklist 禁用门店列表 
     * @support  string $comment 产品描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品
     *
     * @support  int $id id [ require true ]
     * @support  string $module 模块 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  int $occupy_value 占点设置 
     * @support  bool $is_entity 是否为实物 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  array $extend 拓展信息 
     * @support  int $photographic_num 上传照片张数 
     * @support  int $photo_num 照片张数 
     * @support  array $blacklist 禁用门店列表 
     * @support  string $comment 产品描述 
     * @support  array $sku_ids sku Id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品列表
     *
     * @support  int $category_id 类目id 
     * @support  string $name 产品名(模糊查询) 
     * @support  string $full_name 产品全名(模糊查询) 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $module 产品所属模块 
     * @support  string $status 状态,会筛选子节点 
     * @support  bool $c_hidden 预约端是否隐藏,会筛选子节点 
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList();
    }

    /**
     * 全部产品列表
     *
     * @support  int $category_id 类目id 
     * @support  string $name 产品名(模糊查询) 
     * @support  string $full_name 产品全名(模糊查询) 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $module 产品所属模块 
     * @support  string $status 状态,会筛选子节点 
     * @support  bool $c_hidden 预约端是否隐藏,会筛选子节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct();
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部服务组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function serviceGroups () {
        return self::getClass()->serviceGroups();
    }

    /**
     * 获取全部服务项
     *
     * @throws  \Exception
     * @return  array
     */
    public static function serviceLabels () {
        return self::getClass()->serviceLabels();
    }

    /**
     * 添加服务组
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 
     * @support  bool $is_required 是否必填 
     * @support  string $desc 描述 
     * @support  array $extend 扩展字段 
     * @support  int $product_id 产品id 
     * @support  array $services 产品服务 
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceGroup () {
        return self::getClass()->addServiceGroup();
    }

    /**
     * 编辑升级服务组
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 
     * @support  bool $is_required 是否必填 
     * @support  string $comment 描述 
     * @support  array $extend 扩展字段 
     * @support  int $product_id 产品id 
     * @support  array $services 产品服务 
     * @throws  \Exception
     * @return  array
     */
    public static function editServiceGroup () {
        return self::getClass()->editServiceGroup();
    }

    /**
     * 添加服务项
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceLabel (string $name) {
        return self::getClass()->addServiceLabel([
            "name" => $name,
        ]);
    }

    /**
     * 产品全局折扣计算
     *
     * @param  int $store_id  [ require true ]
     * @param  array $product_num_map  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productDiscountCalc (int $store_id, array $product_num_map) {
        return self::getClass()->productDiscountCalc([
            "store_id" => $store_id,
            "product_num_map" => $product_num_map,
        ]);
    }

    /**
     * 修改extend
     *
     * @support  int $id 类目id 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editExtend () {
        return self::getClass()->editExtend();
    }

    /**
     * 设置预约端显示
     *
     * @support  int $id 类目id 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editCHidden () {
        return self::getClass()->editCHidden();
    }

    /**
     * 根据MODULE获取类目/产品树
     *
     * @support  array $module 所属模块组 
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否包含预约端隐藏 
     * @support  int $show_level 起始类目等级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductTreeByModules () {
        return self::getClass()->getProductTreeByModules();
    }

    /**
     * 获取产品定时上下线时间
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCronUpDownTime (int $product_id) {
        return self::getClass()->getCronUpDownTime([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 设置定时上下线时间
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  string $up_time 上线时间 [ require true ]
     * @param  string $down_time 下线时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCronUpDownTime (int $product_id, string $up_time = NULL, string $down_time = NULL) {
        return self::getClass()->setCronUpDownTime([
            "product_id" => $product_id,
            "up_time" => $up_time,
            "down_time" => $down_time,
        ]);
    }

    /**
     * 定时上下线活动
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronUpDownProduct () {
        return self::getClass()->cronUpDownProduct();
    }

    /**
     * 添加产品禁用门店
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  array $store_ids 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStoreToBlacklist (int $product_id, array $store_ids = []) {
        return self::getClass()->addStoreToBlacklist([
            "product_id" => $product_id,
            "store_ids" => $store_ids,
        ]);
    }

    /**
     * 获取产品禁用门店
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductBlacklists (int $product_id) {
        return self::getClass()->getProductBlacklists([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 设置产品预约截止时间
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  string $deadline 预约截止时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAppointmentDeadline (int $product_id, string $deadline = NULL) {
        return self::getClass()->setAppointmentDeadline([
            "product_id" => $product_id,
            "deadline" => $deadline,
        ]);
    }

    /**
     * 产品拖拽排序
     *
     * @param  int $current_id 当前产品id [ require true ]
     * @param  int $target_parent_id 目标位置父级id [ require true ]
     * @param  int $target_sort 目标位置排序值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dragProduct (int $current_id, int $target_parent_id, int $target_sort) {
        return self::getClass()->dragProduct([
            "current_id" => $current_id,
            "target_parent_id" => $target_parent_id,
            "target_sort" => $target_sort,
        ]);
    }

    /**
     * 获取产品占点
     *
     * @support  array $product_group 产品和服务的数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getProductsOccupy () {
        return self::getClass()->getProductsOccupy();
    }

    /**
     * 复制产品
     *
     * @param  int $id 被复制的产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function copyProduct (int $id) {
        return self::getClass()->copyProduct([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品服务组
     *
     * @param  int $service_group_id 产品服务组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductServiceGroup (int $service_group_id) {
        return self::getClass()->deleteProductServiceGroup([
            "service_group_id" => $service_group_id,
        ]);
    }

    /**
     * 清理产品缓存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearCache () {
        return self::getClass()->clearCache();
    }

    /**
     * 编辑推荐产品
     *
     * @support  int $id 推荐配置id [Original type uint] 
     * @support  int $category_id 要配置的类目ID [Original type uint] [ require true ]
     * @support  array $recommend 推荐的单品/套餐ID集合 
     * @support  array $store_ids 推荐的门店ID集合 
     * @support  array $ban_store_ids 禁止推荐的门店ID集合 
     * @support  string $type 推荐类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRecommendProduct () {
        return self::getClass()->editRecommendProduct();
    }

    /**
     * 获取推荐产品/产品组
     *
     * @param  int $category_id 要配置的类目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendProduct (int $category_id) {
        return self::getClass()->getRecommendProduct([
            "category_id" => $category_id,
        ]);
    }

    /**
     * 批量获取服务
     *
     * @param  array $service_ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceByIds (array $service_ids) {
        return self::getClass()->getServiceByIds([
            "service_ids" => $service_ids,
        ]);
    }

    /**
     * 获取全产品宫格别名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGonggeAlias () {
        return self::getClass()->getGonggeAlias();
    }

    /**
     * 2020圣诞照配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function christmasActivitySetting () {
        return self::getClass()->christmasActivitySetting();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}