<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeUserPasswordDirectByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method registerByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method bindEmailByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method checkSignByParams(array $params)
 * @method vipQcsCodeByParams(array $params)
 * @method receiveQcsCodeByParams(array $params)
 * @method sendPhotoUpdatePushByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更改密码（密码为空）
     *
     * @param  string $password 新密码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeUserPasswordDirect (string $password) {
        return self::getClass()->changeUserPasswordDirect([
            "password" => $password,
        ]);
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocol_version 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion();
    }

    /**
     * 注册
     *
     * @support  int $protocol_version 预约协议版本 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $captcha 验证码 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $name 用户昵称 
     * @support  string $head_img 微信头像 
     * @support  string $sex 用户性别 
     * @support  int $channel 渠道号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function register () {
        return self::getClass()->register();
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback () {
        return self::getClass()->feedback();
    }

    /**
     * 绑定邮箱
     *
     * @support  string $email 邮箱地址 [ require true ]
     * @support  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindEmail () {
        return self::getClass()->bindEmail();
    }

    /**
     * 绑定邮箱发放优惠券
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $email email [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  string $choose 选择的券 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCoupon (string $brand, string $email, int $user_id, string $choose) {
        return self::getClass()->sendCoupon([
            "brand" => $brand,
            "email" => $email,
            "user_id" => $user_id,
            "choose" => $choose,
        ]);
    }

    /**
     * 绑定邮箱校验是否通过验证
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户uid [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSign (string $brand, int $user_id) {
        return self::getClass()->checkSign([
            "brand" => $brand,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取屈臣氏code
     *
     * @throws  \Exception
     * @return  string
     */
    public static function vipQcsCode () {
        return self::getClass()->vipQcsCode();
    }

    /**
     * 领取屈臣氏code
     *
     * @throws  \Exception
     * @return  string
     */
    public static function receiveQcsCode () {
        return self::getClass()->receiveQcsCode();
    }

    /**
     * 发送图片更新推送
     *
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPhotoUpdatePush (int $userId, string $orderNo) {
        return self::getClass()->sendPhotoUpdatePush([
            "userId" => $userId,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}