<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Tmp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadPhotoByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method drawAwardByParams(array $params)
 */
class JiGuangActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 返图
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $img 图片路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadPhoto (int $staffId, string $img) {
        return self::getClass()->uploadPhoto([
            "staffId" => $staffId,
            "img" => $img,
        ]);
    }

    /**
     * 获取当前人信息
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfo (int $staffId) {
        return self::getClass()->getStaffInfo([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 抽奖
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function drawAward (int $staffId) {
        return self::getClass()->drawAward([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}