<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPackageByParams(array $params)
 * @method updatePackageByParams(array $params)
 * @method getPackageByParams(array $params)
 * @method getPackageListByParams(array $params)
 * @method upPackageByParams(array $params)
 * @method downPackageByParams(array $params)
 * @method updatePackageTimeByParams(array $params)
 * @method createSubPackageByParams(array $params)
 * @method updateeSubPackageByParams(array $params)
 */
class ProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建套餐
     *
     * @support  string $module 模块 
     * @support  string $name 套餐名称 
     * @support  string $engName 英文套餐名称 
     * @support  array $extend 额外信息 
     * @support  array $metadata 额外信息(后端) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPackage () {
        return self::getClass()->createPackage();
    }

    /**
     * 更新套餐
     *
     * @support  string $module 模块 
     * @support  string $name 套餐名称 
     * @support  string $engName 英文套餐名称 
     * @support  array $extend 额外信息 
     * @support  array $metadata 额外信息(后端) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePackage () {
        return self::getClass()->updatePackage();
    }

    /**
     * 获取套餐详情
     *
     * @support  int $id 套餐id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPackage () {
        return self::getClass()->getPackage();
    }

    /**
     * 获取套餐列表
     *
     * @support  string $module 模块 
     * @support  string $name 套餐名称 
     * @support  string $status 英文套餐名称 
     * @support  int $page 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPackageList () {
        return self::getClass()->getPackageList();
    }

    /**
     * 套餐上架
     *
     * @param  int $id 套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upPackage (int $id) {
        return self::getClass()->upPackage([
            "id" => $id,
        ]);
    }

    /**
     * 套餐下架
     *
     * @param  int $id 套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downPackage (int $id) {
        return self::getClass()->downPackage([
            "id" => $id,
        ]);
    }

    /**
     * 更新套餐上下架时间
     *
     * @support  int $id 套餐id 
     * @support  string $startTime 上架时间 
     * @support  string $endTime 下架时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePackageTime () {
        return self::getClass()->updatePackageTime();
    }

    /**
     * 创建子套餐
     *
     * @support  int $packageId 套餐id [ require true ]
     * @support  string $name 子套餐名称 
     * @support  int $occupyValue 占点数量 
     * @support  array $metadata 配置信息 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSubPackage () {
        return self::getClass()->createSubPackage();
    }

    /**
     * 更新子套餐
     *
     * @support  int $subPackageId 子套餐id 
     * @support  string $name 子套餐名称 
     * @support  int $occupyValue 占点数量 
     * @support  array $metadata 配置信息 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateeSubPackage () {
        return self::getClass()->updateeSubPackage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}