<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method photoLookAppointmentSuccessNoticeByParams(array $params)
 * @method photoLookAppointmentNoticeByParams(array $params)
 * @method photoLookAppointmentInvalidNoticeByParams(array $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约看片成功通知
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentSuccessNotice () {
        return self::getClass()->photoLookAppointmentSuccessNotice();
    }

    /**
     * (大订单)预约看片提醒
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentNotice () {
        return self::getClass()->photoLookAppointmentNotice();
    }

    /**
     * 预约看片时间失效
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentInvalidNotice () {
        return self::getClass()->photoLookAppointmentInvalidNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}