<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method removeByParams(array $params)
 * @method canRefundChangeListByParams(array $params)
 */
class RefundChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转退列表
     *
     * @support  string $order_no 主订单ID 
     * @support  array $store_ids 门店ID 
     * @support  string $created_at_start 申请时间-开始 
     * @support  string $created_at_end 申请时间-结束 
     * @support  string $passed_at_start 通过时间-开始 
     * @support  string $passed_at_end 通过时间-结束 
     * @support  string $phone 手机号 
     * @support  string $status 状态 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 转退详情
     *
     * @support  int $id 转退id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 创建转退
     *
     * @support  int $refund_id 退款ID [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 通过转退
     *
     * @support  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass () {
        return self::getClass()->pass();
    }

    /**
     * 通过转退
     *
     * @support  int $id 退款id [ require true ]
     * @support  string $reason 拒绝理由 
     * @throws  \Exception
     * @return  array
     */
    public static function reject () {
        return self::getClass()->reject();
    }

    /**
     * 删除转退
     *
     * @param  int $id 退款id [ require true ]
     * @support  string $reason 拒绝理由 
     * @throws  \Exception
     * @return  array
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 可转退列表
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $type 转退类型 
     * @throws  \Exception
     * @return  array
     */
    public static function canRefundChangeList () {
        return self::getClass()->canRefundChangeList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RefundChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RefundChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}