<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method afterZeroPayByParams(array $params)
 * @method afterRetailOrderZeroPayByParams(array $params)
 * @method callbackByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零元支付完成推送通知
     *
     * @support  int $orderId order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterZeroPay () {
        return self::getClass()->afterZeroPay();
    }

    /**
     * 零售订单零元支付完成推送通知
     *
     * @param  array $retailOrderNums retail order nums [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterRetailOrderZeroPay (array $retailOrderNums) {
        return self::getClass()->afterRetailOrderZeroPay([
            "retailOrderNums" => $retailOrderNums,
        ]);
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function callback () {
        return self::getClass()->callback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}