<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method areaIdsBindPriceByParams(array $params)
 * @method areaIdsUnbindPriceByParams(array $params)
 * @method updateAreaIdsByParams(array $params)
 * @method updatePriceByParams(array $params)
 * @method deletePriceByParams(array $params)
 * @method areaBindStoreByParams(array $params)
 * @method areaAddByParams(array $params)
 * @method areaAllByParams(array $params)
 * @method areaUpdateByParams(array $params)
 * @method areaDeleteByParams(array $params)
 * @method updateJxjyGonggePriceByParams(array $params)
 */
class ProductArea {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 多个价格区绑定价格
     *
     * @support  int $product_id 产品或服务id [ require true ]
     * @support  array $price_area_ids 价格区ids [ require true ]
     * @support  int $price_id 价格id 
     * @support  float $price 实际价格 [Original type double] 
     * @support  float $original_price 原始价格 [Original type double] 
     * @support  float $add_people_price 加人加价 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaIdsBindPrice () {
        return self::getClass()->areaIdsBindPrice();
    }

    /**
     * 多个价格区解绑价格
     *
     * @support  array $price_area_ids 价格区ids [ require true ]
     * @support  int $price_id 价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaIdsUnbindPrice () {
        return self::getClass()->areaIdsUnbindPrice();
    }

    /**
     * 更新价格中的价格区(新增和移除)
     *
     * @support  int $product_id 产品或服务id [ require true ]
     * @support  array $new_area_ids 需新增的价格区ids 
     * @support  array $remove_area_ids 需移除的价格区ids 
     * @support  int $price_id 价格id 
     * @support  float $price 实际价格 [Original type double] 
     * @support  float $original_price 原始价格 [Original type double] 
     * @support  float $add_people_price 加人加价 [Original type double] 
     * @support  array $jxjy_price 加修加印信息 
     * @support  float $jxjy_price.original 加修加印-原价 [Original type unsignedDouble] 
     * @support  float $jxjy_price.now 加修加印-现价 [Original type unsignedDouble] 
     * @support  float $jxjy_price.add_people 加修加印-加人加价 [Original type unsignedDouble] 
     * @support  int $jxjy_price.min_people 加修加印-最小人数 [Original type uint] 
     * @support  float $jxjy_price.max_people 加修加印-最大人数 [Original type unsignedDouble] 
     * @support  array $gongge_price 宫格信息 
     * @support  array $gongge_price.discount 宫格信息-优惠信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAreaIds () {
        return self::getClass()->updateAreaIds();
    }

    /**
     * 更新价格
     *
     * @support  int $product_id 产品或服务id 
     * @support  int $price_id 价格id 
     * @support  float $price 更新后实际价格 [Original type double] [ require true ]
     * @support  float $original_price 更新后原始价格 [Original type double] [ require true ]
     * @support  float $add_people_price 更新后加人加价 [Original type double] [ require true ]
     * @support  array $jxjy_price 加修加印信息 
     * @support  float $jxjy_price.original 加修加印-原价 [Original type unsignedDouble] 
     * @support  float $jxjy_price.now 加修加印-现价 [Original type unsignedDouble] 
     * @support  float $jxjy_price.add_people 加修加印-加人加价 [Original type unsignedDouble] 
     * @support  int $jxjy_price.min_people 加修加印-最小人数 [Original type uint] 
     * @support  float $jxjy_price.max_people 加修加印-最大人数 [Original type unsignedDouble] 
     * @support  array $gongge_price 宫格信息 
     * @support  array $gongge_price.discount 宫格信息-优惠信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePrice () {
        return self::getClass()->updatePrice();
    }

    /**
     * 删除价格
     *
     * @support  int $price_id 价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePrice () {
        return self::getClass()->deletePrice();
    }

    /**
     * 分区绑定门店(非增量)
     *
     * @param  int $area_id 价格区id [ require true ]
     * @param  array $store_ids 门店组 [ require true ]
     * @param  string $type 分区类型(价格区,服装区) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaBindStore (int $area_id, array $store_ids = [], string $type = 'price') {
        return self::getClass()->areaBindStore([
            "area_id" => $area_id,
            "store_ids" => $store_ids,
            "type" => $type,
        ]);
    }

    /**
     * 新增门店分区
     *
     * @param  string $name 价格区名称 [ require true ]
     * @param  string $module 价格区所属品牌 [ require true ]
     * @param  string $type 分区类型(价格区,服装区) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAdd (string $name, string $module, string $type = 'price') {
        return self::getClass()->areaAdd([
            "name" => $name,
            "module" => $module,
            "type" => $type,
        ]);
    }

    /**
     * 所有门店分区
     *
     * @param  string $module 价格区所属品牌 [ require true ]
     * @param  string $type 分区类型(价格区,服装区)(不传表示全部) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAll (string $module, string $type = '') {
        return self::getClass()->areaAll([
            "module" => $module,
            "type" => $type,
        ]);
    }

    /**
     * 编辑门店分区
     *
     * @param  int $area_id 分区id [ require true ]
     * @param  string $name 分区名称 [ require true ]
     * @param  string $module 分区所属品牌 [ require true ]
     * @param  string $type 分区类型(价格区,服装区) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaUpdate (int $area_id, string $name, string $module, string $type = 'price') {
        return self::getClass()->areaUpdate([
            "area_id" => $area_id,
            "name" => $name,
            "module" => $module,
            "type" => $type,
        ]);
    }

    /**
     * 删除门店分区
     *
     * @param  int $area_id 价格区id [ require true ]
     * @param  string $type 分区类型(价格区,服装区) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaDelete (int $area_id, string $type = 'price') {
        return self::getClass()->areaDelete([
            "area_id" => $area_id,
            "type" => $type,
        ]);
    }

    /**
     * 更新加修加印价格
     *
     * @support  int $price_id 价格id 
     * @support  array $jxjyPrice 加修加印信息 [ require true ]
     * @support  float $jxjyPrice.original 加修加印-原价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.now 加修加印-现价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.addPeople 加修加印-加人加价 [Original type unsignedDouble] 
     * @support  int $jxjyPrice.minPeople 加修加印-最小人数 [Original type uint] 
     * @support  float $jxjyPrice.maxPeople 加修加印-最大人数 [Original type unsignedDouble] 
     * @support  array $gonggeInfo 宫格信息 
     * @support  array $gonggeInfo.discount 宫格信息-优惠信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateJxjyGonggePrice () {
        return self::getClass()->updateJxjyGonggePrice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductArea');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductArea');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}