<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Taobao;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receiveMsgByParams(array $params)
 * @method getWorkcardListByParams(array $params)
 * @method getIdentifyInfoByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 */
class Workcard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 1. 购买订单，工单创建
     * 2. 消息推送【消息中间件】
     * 3. 工单查询订单
     * 5. 可多次操作，每次操作都会重新推送一条消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMsg () {
        return self::getClass()->receiveMsg();
    }

    /**
     * 工单查询接口
     *
     * @support  int $service_store_id  网点门店id 
     * @support  string $identify_code 核销码 
     * @support  int $work_card_id 工单id [Original type uint] 
     * @support  string $date_start   开始时间 
     * @support  string $date_end 截止日期 
     * @support  string $biz_order_id 淘宝交易订单号。主订单或子订单均可 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getWorkcardList () {
        return self::getClass()->getWorkcardList();
    }

    /**
     * 获取核销信息
     *
     * @param  int $workcard_id 工单ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getIdentifyInfo (int $workcard_id) {
        return self::getClass()->getIdentifyInfo([
            "workcard_id" => $workcard_id,
        ]);
    }

    /**
     * 工单预约[反向修改预约时间]
     *
     * @support  int $workcard_id 工单id [Original type uint] [ require true ]
     * @support  string $reserve_time 服务开始时间 [ require true ]
     * @support  string $reserve_remark 预约备注信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Taobao\Workcard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Taobao\Workcard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}