<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Taobao;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveServiceStoreByParams(array $params)
 * @method offlineServiceStoreByParams(array $params)
 */
class ServiceStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建网点
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveServiceStore (int $store_id) {
        return self::getClass()->saveServiceStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 删除网点【谨慎操作，一旦删除就无法使用该网点服务ID】
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineServiceStore (int $store_id) {
        return self::getClass()->offlineServiceStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Taobao\ServiceStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Taobao\ServiceStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}