<?php
namespace Mainto\Bridge\Invokes\HimoProduct\TaoBao;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method deleteByParams(array $params)
 * @method editByParams(array $params)
 * @method searchByParams(array $params)
 */
class ServiceStoreCapacity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建服务容量
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  string $date 参照日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $store_id, string $date) {
        return self::getClass()->create([
            "store_id" => $store_id,
            "date" => $date,
        ]);
    }

    /**
     * 删除网点容量
     *
     * @param  int $store_id 门店Id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $store_id) {
        return self::getClass()->delete([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 编辑网点容量[编辑某一天的实时库存]
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  string $date 日期 [ require true ]
     * @param  string $time_start 开始时间点 [ require true ]
     * @param  string $time_end 截止时间点 [ require true ]
     * @param  int $quantity 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit (int $store_id, string $date, string $time_start, string $time_end, int $quantity) {
        return self::getClass()->edit([
            "store_id" => $store_id,
            "date" => $date,
            "time_start" => $time_start,
            "time_end" => $time_end,
            "quantity" => $quantity,
        ]);
    }

    /**
     * 查询网点容量
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (int $store_id, string $date_end, string $date_start) {
        return self::getClass()->search([
            "store_id" => $store_id,
            "date_end" => $date_end,
            "date_start" => $date_start,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'TaoBao\ServiceStoreCapacity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'TaoBao\ServiceStoreCapacity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}