<?php
namespace Mainto\Bridge\Invokes\HimoProduct\TaoBao;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveServiceAbilityByParams(array $params)
 * @method delServiceabilityByParams(array $params)
 */
class ServiceStoreAbility {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存服务能力
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  array $service_sku_codes 支持的服务列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveServiceAbility (int $store_id, array $service_sku_codes) {
        return self::getClass()->saveServiceAbility([
            "store_id" => $store_id,
            "service_sku_codes" => $service_sku_codes,
        ]);
    }

    /**
     * 删除服务能力【全部删除-慎重】
     *
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delServiceability (int $store_id) {
        return self::getClass()->delServiceability([
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'TaoBao\ServiceStoreAbility');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'TaoBao\ServiceStoreAbility');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}