<?php
namespace Mainto\Bridge\Invokes\HimoProduct\TaoBao;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reservedPointsByParams(array $params)
 * @method redirectByParams(array $params)
 */
class Carbon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存容量是一个模板数据，使用模板容量数据生成每天的库存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservedPoints () {
        return self::getClass()->reservedPoints();
    }

    /**
     * 用户授权回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function redirect () {
        return self::getClass()->redirect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'TaoBao\Carbon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'TaoBao\Carbon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}