<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCartByParams(array $params)
 * @method getUserCartByParams(array $params)
 * @method checkProductExistByParams(array $params)
 * @method clearCartByParams(array $params)
 */
class ShoppingCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加购物车
     *
     * @support  string $token token [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  int $peopleNum 人数 [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  array $serviceIds 服务Ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCart () {
        return self::getClass()->addCart();
    }

    /**
     * 获取用户购物车信息
     *
     * @support  string $token token [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCart () {
        return self::getClass()->getUserCart();
    }

    /**
     * 检测购物车中是否包含该产品
     *
     * @support  string $token token [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkProductExist () {
        return self::getClass()->checkProductExist();
    }

    /**
     * 清空购物车
     *
     * @support  string $token token [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  int $productId 产品id 
     * @support  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearCart () {
        return self::getClass()->clearCart();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\ShoppingCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\ShoppingCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}