<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method oldCreateByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method confirmByParams(array $params)
 * @method detailByParams(array $params)
 * @method refuseByParams(array $params)
 * @method reasonByParams(array $params)
 * @method fastRefundToGiftCardByParams(array $params)
 * @method subOrderRefundStatusByParams(array $params)
 * @method canRefundDetailByIdsByParams(array $params)
 * @method changeProductByParams(array $params)
 * @method visaChangeByParams(array $params)
 * @method confirmHandRefundByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入(旧数据)
     *
     * @support  int $order_id 子订单id [ require true ]
     * @support  int $scale 退款比例 
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function oldCreate () {
        return self::getClass()->oldCreate();
    }

    /**
     * 预约退款录入
     *
     * @support  int $sub_order_id 子订单id [ require true ]
     * @support  string $refund_type 退款类型 [ require true ]
     * @support  string $channel 退款通道 [ require true ]
     * @support  array $refund_item 退款项 
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  array $reason_ids 退款ids [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 退款列表
     *
     * @support  string $order_no 主订单ID 
     * @support  string $status 状态 
     * @support  array $status_list 状态array 
     * @support  int $store_id 门店ID 
     * @support  string $pay_type 支付方式 
     * @support  string $apply_time_start 申请时间-开始 
     * @support  string $apply_time_end 申请时间-结束 
     * @support  string $process_time_start 处理时间-开始 
     * @support  string $process_time_end 处理时间-结束 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款处理
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 退款详情
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 拒绝退款
     *
     * @support  int $id 退款id [ require true ]
     * @support  string $reason 拒绝理由 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuse () {
        return self::getClass()->refuse();
    }

    /**
     * 退款理由
     *
     * @support  string $category 分类：category_user_refund,category_admin_refund 
     * @support  int $parent_id  
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * 快速退款至礼品卡
     *
     * @support  int $sub_order_id 子订单id [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fastRefundToGiftCard () {
        return self::getClass()->fastRefundToGiftCard();
    }

    /**
     * 根据子订单ID获取子订单项退款信息
     *
     * @support  int $sub_order_id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function subOrderRefundStatus () {
        return self::getClass()->subOrderRefundStatus();
    }

    /**
     * 获取部分子订单项可退金额
     *
     * @support  int $sub_order_id 子订单ID [ require true ]
     * @support  array $refund_item 子订单项 [ require true ]
     * @support  array $detail 产品详情 
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundDetailByIds () {
        return self::getClass()->canRefundDetailByIds();
    }

    /**
     * 换产品（单个产品）
     *
     * @support  int $sub_order_id 子订单ID [ require true ]
     * @support  int $refund_item_id 退款产品id [ require true ]
     * @support  int $input_staff_id 主推人id 
     * @support  array $detail 产品详情 [ require true ]
     * @support  string $pay_type 支付方式 
     * @support  float $real_money 手动输入支付金额 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProduct () {
        return self::getClass()->changeProduct();
    }

    /**
     * 签证/同类互换
     *
     * @support  int $sub_order_id 子订单号 [ require true ]
     * @support  int $input_staff_id 录入人伙伴ID 
     * @support  array $detail 产品详情 [ require true ]
     * @support  int $refund_item_id 退款项id [ require true ]
     * @support  int $service_id 退款项服务id [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function visaChange () {
        return self::getClass()->visaChange();
    }

    /**
     * 手动退款再次确认
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function confirmHandRefund (int $id) {
        return self::getClass()->confirmHandRefund([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}