<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkNameExistsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method allByParams(array $params)
 */
class PurchasePackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测名称是否存在
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkNameExists (string $name) {
        return self::getClass()->checkNameExists([
            "name" => $name,
        ]);
    }

    /**
     * create
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $storeType 适用门店类型 [ require true ]
     * @param  string $desc 描述 [ require true ]
     * @param  array $skuInfo 物料信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $storeType, string $desc, array $skuInfo) {
        return self::getClass()->create([
            "name" => $name,
            "storeType" => $storeType,
            "desc" => $desc,
            "skuInfo" => $skuInfo,
        ]);
    }

    /**
     * update
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $storeType 适用门店类型 
     * @support  string $desc 描述 
     * @param  array $skuInfo 物料信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, array $skuInfo) {
        return self::getClass()->update([
            "id" => $id,
            "skuInfo" => $skuInfo,
        ]);
    }

    /**
     * changeStatus
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $status 上下线状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus (int $id, string $status) {
        return self::getClass()->changeStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * delete
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * list
     *
     * @support  string $name name 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * detail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * all
     *
     * @support  string $name name 
     * @support  string $status status 
     * @support  string $storeType storeType 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\PurchasePackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\PurchasePackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}