<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSNQuestionByParams(array $params)
 * @method getSNStatusByParams(array $params)
 * @method createSNByParams(array $params)
 * @method getNPSStatusByParams(array $params)
 * @method createNPSByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取SN问卷
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSNQuestion () {
        return self::getClass()->getSNQuestion();
    }

    /**
     * 获取SN状态
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSNStatus () {
        return self::getClass()->getSNStatus();
    }

    /**
     * 提交SN问卷
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  array $answers 答案组 [ require true ]
     * @support  string $note sn意见 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSN () {
        return self::getClass()->createSN();
    }

    /**
     * 获取NPS状态
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNPSStatus () {
        return self::getClass()->getNPSStatus();
    }

    /**
     * 提交NPS问卷
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $nps_all 总分 [ require true ]
     * @support  int $nps_receptionist 门市客服评分 [ require true ]
     * @support  int $nps_cameraman 摄影师平分 [ require true ]
     * @support  int $nps_dresser 化妆师评分 [ require true ]
     * @support  int $nps_retoucher 看片师评分 [ require true ]
     * @support  string $nps_note 其他反馈 
     * @support  int $is_sn 是否参与SN [ require true ]
     * @support  int $is_share 是否参与分享 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNPS () {
        return self::getClass()->createNPS();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}