<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method deletedByParams(array $params)
 * @method listByParams(array $params)
 * @method upLoadImageByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 */
class KfMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加客服消息
     *
     * @support  string $message_name 客服消息名称 [ require true ]
     * @support  string $message_key 客服消息英文名称 [ require true ]
     * @support  string $message_text 客服消息文案 
     * @support  array $message_media_ids 图片media_ids 
     * @support  array $product_ids 产品ids 
     * @support  array $store_ids 门店ids 
     * @support  int $delay_time 延迟时间 单位分钟 
     * @support  int $hit_product_num 命中产品数 
     * @support  string $hit_condition 命中情况 [ require true ]
     * @support  int $start_time 上线时间 
     * @support  int $end_time 下线时间 
     * @support  int $staff_id 创建人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 添加客服消息
     *
     * @support  int $kf_message_id 客服消息id [ require true ]
     * @support  string $message_name 客服消息名称 [ require true ]
     * @support  string $message_key 客服消息英文名称 [ require true ]
     * @support  string $message_text 客服消息文案 
     * @support  array $message_media_ids 图片media_ids 
     * @support  array $product_ids 产品ids 
     * @support  array $store_ids 门店ids 
     * @support  int $delay_time 延迟时间 单位分钟 
     * @support  int $hit_product_num 命中产品数 
     * @support  string $hit_condition 命中情况 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除客服消息
     *
     * @support  int $kf_message_id 客服消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleted () {
        return self::getClass()->deleted();
    }

    /**
     * 客服消息列表
     *
     * @support  int $page 页码 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 客服消息列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upLoadImage () {
        return self::getClass()->upLoadImage();
    }

    /**
     * 发送客服消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\KfMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\KfMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}