<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method setStatusByParams(array $params)
 * @method listByParams(array $params)
 * @method infoByParams(array $params)
 * @method upLoadImageByParams(array $params)
 * @method upLoadArticleByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 */
class KfMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加客服消息
     *
     * @support  string $message_name 客服消息名称(不可重复) [ require true ]
     * @support  string $message_key 客服消息英文名称(不可重复) [ require true ]
     * @support  string $message_text 客服消息文案 
     * @support  array $image_media 图片media_info 
     * @support  array $article_media 图文消息media_info 
     * @support  array $product_ids 产品ids 
     * @support  array $store_ids 门店ids 
     * @support  int $delay_time 延迟时间 单位分钟 
     * @support  int $hit_product_num 匹配产品数 
     * @support  string $hit_condition 匹配情况 order_complete:订单完成  wait_shooting:等待拍摄 [ require true ]
     * @support  string $start_time 上线时间 
     * @support  string $end_time 下线时间 
     * @support  int $status 上下线操作 0:下线 1:上线 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 更新客服消息
     *
     * @support  int $id 客服消息id [ require true ]
     * @support  string $message_name 客服消息名称(不可重复) [ require true ]
     * @support  string $message_key 客服消息英文名称(不可重复) [ require true ]
     * @support  string $message_text 客服消息文案 
     * @support  array $image_media 图片media_info 
     * @support  array $article_media 图文消息media_info 
     * @support  array $product_ids 产品ids 
     * @support  array $store_ids 门店ids 
     * @support  int $delay_time 延迟时间 单位分钟 
     * @support  int $hit_product_num 命中产品数 
     * @support  string $hit_condition 匹配情况 order_complete:订单完成  wait_shooting:等待拍摄 [ require true ]
     * @support  string $start_time 上线时间 
     * @support  string $end_time 下线时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 客服消息上下线
     *
     * @support  int $id 客服消息id [ require true ]
     * @support  int $status 上下线操作 0:下线 1:上线 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStatus () {
        return self::getClass()->setStatus();
    }

    /**
     * 客服消息列表
     *
     * @support  int $page 页码 
     * @support  int $page_size 分页数 
     * @support  array $product_ids 产品 搜索 
     * @support  string $message_name 客服消息名称 搜索 
     * @support  string $message_key 客服消息名称 搜索 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 客服消息详情
     *
     * @support  int $id 客服消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 上传图片
     *
     * @support  string $img_path 图片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upLoadImage () {
        return self::getClass()->upLoadImage();
    }

    /**
     * 上传图文消息
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $thumb_media_id 图文消息的封面图片，必须是永久mediaId [ require true ]
     * @support  int $show_cover_pic 是否显示封面，0:不显示 1:显示 [ require true ]
     * @support  string $content 图文消息的具体内容 [ require true ]
     * @support  string $content_source_url 图文消息的原文地址url [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upLoadArticle () {
        return self::getClass()->upLoadArticle();
    }

    /**
     * 发送客服消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\KfMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\KfMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}