<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method submitByParams(array $params)
 * @method resubmitByParams(array $params)
 */
class PurchaseGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建集采
     *
     * @param  string $storeType 门店类型 [ require true ]
     * @param  string $remark 下单原因 [ require true ]
     * @param  array $storeIds 门店id数组 [ require true ]
     * @param  array $skuInfo 物料sku数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $storeType, string $remark, array $storeIds, array $skuInfo) {
        return self::getClass()->create([
            "storeType" => $storeType,
            "remark" => $remark,
            "storeIds" => $storeIds,
            "skuInfo" => $skuInfo,
        ]);
    }

    /**
     * 修改集采
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $storeType 门店类型 
     * @support  string $remark 下单原因 
     * @param  array $storeInfo 门店id数组 [ require true ]
     * @param  array $skuInfo 物料sku数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, array $storeInfo, array $skuInfo) {
        return self::getClass()->update([
            "id" => $id,
            "storeInfo" => $storeInfo,
            "skuInfo" => $skuInfo,
        ]);
    }

    /**
     * 集采列表[分页]
     *
     * @support  string $startAt start_at 
     * @support  string $endAt end_at 
     * @support  int $createBy 下单人工号 [Original type uint] 
     * @support  string $status 状态 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 集采详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 集采提交
     *
     * @param  int $id 集采申请id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 集采重新提交
     *
     * @param  int $id 失败记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resubmit (int $id) {
        return self::getClass()->resubmit([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\PurchaseGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\PurchaseGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}