<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeByParams(array $params)
 * @method staffByParams(array $params)
 * @method leaveByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method staffInfoByParams(array $params)
 * @method storesByParams(array $params)
 * @method createByParams(array $params)
 */
class Galaxy {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店信息
     *
     * @support  array $store_ids 门店ids 
     * @support  string $store_name 门店名称 
     * @support  bool $with_trashed 是否现显示已删除数据 
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 员工是否存在
     *
     * @support  int $staff_id 工号 [ require true ]
     * @support  string $token token [ require true ]
     * @support  bool $with_trashed 是否包含已删除的数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 离职员工
     *
     * @support  int $staff_id 工号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function leave () {
        return self::getClass()->leave();
    }

    /**
     * 更换员工部门（门店更换）
     *
     * @support  string $token token [ require true ]
     * @support  int $staff_id 工号 [ require true ]
     * @support  int $department_id 新门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStore () {
        return self::getClass()->changeStore();
    }

    /**
     * 获取员工信息
     *
     * @support  int $staff_id 工号 [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffInfo () {
        return self::getClass()->staffInfo();
    }

    /**
     * 获取所有门店信息
     *
     * @support  string $token token [ require true ]
     * @support  bool $with_trashed 是否包含已删除数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function stores () {
        return self::getClass()->stores();
    }

    /**
     * 新增伙伴
     *
     * @support  int $staff_id 工号 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $token token [ require true ]
     * @support  string $dingding_uid 钉钉账号 
     * @support  int $job_id 职位ID [ require true ]
     * @support  int $department_id 部门id [ require true ]
     * @support  string $nickname 花名 
     * @support  string $phone 手机号 
     * @support  int $level 职级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Galaxy');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Galaxy');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}