<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method baseDetailByParams(array $params)
 * @method batchDetailByParams(array $params)
 * @method getDetailListByCategoryIdByParams(array $params)
 * @method getProductsByParams(array $params)
 * @method getStoreIdByProductCityByParams(array $params)
 * @method getProductsByCategoryIdsByParams(array $params)
 * @method getKidsProductByParams(array $params)
 * @method categoriesByParams(array $params)
 * @method getRecommendProductByParams(array $params)
 * @method getProductGiftRuleByParams(array $params)
 * @method productSearchByParams(array $params)
 * @method kidsProductSearchByParams(array $params)
 * @method haveCategoryStoreIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品详情
     *
     * @param  int $product_id 产品ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $product_id, int $store_id) {
        return self::getClass()->detail([
            "product_id" => $product_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取产品详情(无需门店)
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function baseDetail (int $product_id) {
        return self::getClass()->baseDetail([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 批量获取多个产品详情
     *
     * @param  array $product_ids 产品ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchDetail (array $product_ids, int $store_id) {
        return self::getClass()->batchDetail([
            "product_ids" => $product_ids,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取一个门店下某个类目所有的产品
     *
     * @param  int $category_id 类目 [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailListByCategoryId (int $category_id, int $store_id) {
        return self::getClass()->getDetailListByCategoryId([
            "category_id" => $category_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取所有产品
     *
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProducts (int $store_id) {
        return self::getClass()->getProducts([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 通过城市id和产品id获取有该产品的门店id
     *
     * @param  int $product_id 产品ID [ require true ]
     * @param  int $city_id 城市ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreIdByProductCity (int $city_id, int $product_id) {
        return self::getClass()->getStoreIdByProductCity([
            "city_id" => $city_id,
            "product_id" => $product_id,
        ]);
    }

    /**
     * 根据类目ids获取产品
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  array $category_ids 类目id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByCategoryIds (int $store_id, array $category_ids) {
        return self::getClass()->getProductsByCategoryIds([
            "store_id" => $store_id,
            "category_ids" => $category_ids,
        ]);
    }

    /**
     * 通过id获取kids产品
     *
     * @param  int $product_id kids产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsProduct (int $product_id) {
        return self::getClass()->getKidsProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 根据类目ids获取类目
     *
     * @param  array $category_ids 类目id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function categories (array $category_ids) {
        return self::getClass()->categories([
            "category_ids" => $category_ids,
        ]);
    }

    /**
     * 获取推荐产品/产品组
     *
     * @param  int $category_id 要配置的类目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendProduct (int $category_id) {
        return self::getClass()->getRecommendProduct([
            "category_id" => $category_id,
        ]);
    }

    /**
     * 获取赠品规则
     *
     * @support  int $node_id 节点ID [ require true ]
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $group 品牌分组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductGiftRule () {
        return self::getClass()->getProductGiftRule();
    }

    /**
     * 产品搜索
     *
     * @support  string $name 搜索名称 [ require true ]
     * @support  array $store_map 门店类型和id的map 
     * @support  int $city_id 城市id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSearch () {
        return self::getClass()->productSearch();
    }

    /**
     * 儿童产品搜索
     *
     * @support  string $name 搜索名称 [ require true ]
     * @support  array $store_map 门店类型和id的map [ require true ]
     * @support  int $city_id 城市id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function kidsProductSearch () {
        return self::getClass()->kidsProductSearch();
    }

    /**
     * 过滤出有该类目的门店ids
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  int $category_id 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveCategoryStoreIds () {
        return self::getClass()->haveCategoryStoreIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}