<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method threeHourReminderByParams(array $params)
 * @method dayReminderByParams(array $params)
 * @method sendSNByParams(array $params)
 * @method sendOrderNotifyByParams(array $params)
 * @method samplePhotoExpireNoticeByParams(array $params)
 * @method performanceShotDailyByParams(array $params)
 * @method reservationLogByParams(array $params)
 * @method reservationAnalyzeByParams(array $params)
 * @method newUserCouponByParams(array $params)
 * @method reservationChangeByParams(array $params)
 * @method refreshSessionByParams(array $params)
 * @method birthGiftByParams(array $params)
 * @method precisePushByParams(array $params)
 * @method returnGiftCardByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method effectCompareByParams(array $params)
 * @method pushCompleteOrderMessageByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每十分钟执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function threeHourReminder () {
        return self::getClass()->threeHourReminder();
    }

    /**
     * 每天11点-18点每小时执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dayReminder () {
        return self::getClass()->dayReminder();
    }

    /**
     * 每5分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSN () {
        return self::getClass()->sendSN();
    }

    /**
     * 每天11-18的每次半点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderNotify () {
        return self::getClass()->sendOrderNotify();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function samplePhotoExpireNotice () {
        return self::getClass()->samplePhotoExpireNotice();
    }

    /**
     * 每天2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function performanceShotDaily () {
        return self::getClass()->performanceShotDaily();
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationLog () {
        return self::getClass()->reservationLog();
    }

    /**
     * 每天0点5分执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationAnalyze () {
        return self::getClass()->reservationAnalyze();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function newUserCoupon () {
        return self::getClass()->newUserCoupon();
    }

    /**
     * 每天11点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationChange () {
        return self::getClass()->reservationChange();
    }

    /**
     * 每月的1号15号2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshSession () {
        return self::getClass()->refreshSession();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function birthGift () {
        return self::getClass()->birthGift();
    }

    /**
     * 每天晚上九点半执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function precisePush () {
        return self::getClass()->precisePush();
    }

    /**
     * 未接受礼品卡退还
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnGiftCard () {
        return self::getClass()->returnGiftCard();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete () {
        return self::getClass()->serviceComplete();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function effectCompare () {
        return self::getClass()->effectCompare();
    }

    /**
     * 每天12点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushCompleteOrderMessage () {
        return self::getClass()->pushCompleteOrderMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}