<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderClothByParams(array $params)
 * @method chooseClothByParams(array $params)
 */
class OrderCloth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单拍前衣服
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderCloth (int $order_id) {
        return self::getClass()->orderCloth([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 提交选择的照片
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @support  array $clothes 图片数组 [ require true ]
     * @support  string $upper 上衣 
     * @support  string $lower 下装 
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseCloth () {
        return self::getClass()->chooseCloth();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\OrderCloth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\OrderCloth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}