<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method areaBindPriceByParams(array $params)
 * @method areaBindStoreByParams(array $params)
 * @method areaAddByParams(array $params)
 * @method areaAllByParams(array $params)
 * @method areaUpdateByParams(array $params)
 * @method areaDeleteByParams(array $params)
 */
class ProductArea {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 价格区绑定价格
     *
     * @param  string $node_type 价格类型 [ require true ]
     * @param  int $price_area_id 价格区id [ require true ]
     * @param  int $price_id 价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaBindPrice (string $node_type, int $price_area_id, int $price_id) {
        return self::getClass()->areaBindPrice([
            "node_type" => $node_type,
            "price_area_id" => $price_area_id,
            "price_id" => $price_id,
        ]);
    }

    /**
     * 价格区绑定门店(非增量)
     *
     * @param  int $price_area_id 价格区id [ require true ]
     * @param  array $store_ids 门店组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaBindStore (int $price_area_id, array $store_ids) {
        return self::getClass()->areaBindStore([
            "price_area_id" => $price_area_id,
            "store_ids" => $store_ids,
        ]);
    }

    /**
     * 新增价格区
     *
     * @param  string $name 价格区名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAdd (string $name) {
        return self::getClass()->areaAdd([
            "name" => $name,
        ]);
    }

    /**
     * 所有价格区
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaAll () {
        return self::getClass()->areaAll();
    }

    /**
     * 编辑价格区
     *
     * @param  int $price_area_id 价格区id [ require true ]
     * @param  string $name 价格区名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaUpdate (int $price_area_id, string $name) {
        return self::getClass()->areaUpdate([
            "price_area_id" => $price_area_id,
            "name" => $name,
        ]);
    }

    /**
     * 删除价格区
     *
     * @param  int $price_area_id 价格区id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaDelete (int $price_area_id) {
        return self::getClass()->areaDelete([
            "price_area_id" => $price_area_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductArea');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductArea');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}