<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method typesByParams(array $params)
 * @method bindByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getClassificationStoreByParams(array $params)
 */
class StoreClassification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据类型获取分类列表
     *
     * @param  string $type 区域划分类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $type = 'price_area') {
        return self::getClass()->list([
            "type" => $type,
        ]);
    }

    /**
     * 获取分类类型列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function types () {
        return self::getClass()->types();
    }

    /**
     * 分类绑定门店
     *
     * @support  int $id 分组id [Original type uint] [ require true ]
     * @support  array $store_ids 门店id数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 创建地区分类
     *
     * @param  string $type 分类类型(price_area(价格分区)|hmt_store_area(地理区域)|store_type(类型分区)) [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  int $num 分类ID [ require true ]
     * @param  array $extend 拓展信息(包含自动更新规则) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $type, string $name, int $num = -1, array $extend = []) {
        return self::getClass()->create([
            "type" => $type,
            "name" => $name,
            "num" => $num,
            "extend" => $extend,
        ]);
    }

    /**
     * 修改分类
     *
     * @param  int $id 分类ID [Original type uint] [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  array $extend 拓展信息(包含自动更新规则) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, array $extend = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 分类详情
     *
     * @param  int $id 分类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取某些门店分类下的门店列表
     *
     * @param  array $ids 分类ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getClassificationStore (array $ids) {
        return self::getClass()->getClassificationStore([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\StoreClassification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\StoreClassification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}