<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method oldCreateByParams(array $params)
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method confirmByParams(array $params)
 * @method createAndConfirmByParams(array $params)
 * @method fixDubiousRefundResultByParams(array $params)
 * @method fixRefundAccountByParams(array $params)
 * @method detailByParams(array $params)
 * @method refuseByParams(array $params)
 * @method reasonByParams(array $params)
 * @method fastRefundToGiftCardByParams(array $params)
 * @method subOrderRefundStatusByParams(array $params)
 * @method canRefundDetailByIdsByParams(array $params)
 * @method changeProductByParams(array $params)
 * @method visaChangeByParams(array $params)
 * @method confirmHandRefundByParams(array $params)
 * @method createStaffPayByParams(array $params)
 * @method confirmStaffPayByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入(旧数据)
     *
     * @support  int $order_id 子订单id [ require true ]
     * @support  int $scale 退款比例 
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function oldCreate () {
        return self::getClass()->oldCreate();
    }

    /**
     * 预约退款录入
     *
     * @support  int $sub_order_id 子订单id [ require true ]
     * @support  string $refund_type 退款类型 
     * @support  string $channel 退款通道 
     * @support  array $refund_item 退款项 
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  array $reason_ids 退款ids [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 退款列表
     *
     * @support  string $order_no 主订单ID 
     * @support  string $status 状态 
     * @support  string $brand 品牌 
     * @support  string $status_list 状态组(,拼接) 
     * @support  int $store_id 门店ID 
     * @support  array $store_ids 门店ID 
     * @support  string $pay_type 支付方式 
     * @support  string $apply_time_start 申请时间-开始 
     * @support  string $apply_time_end 申请时间-结束 
     * @support  string $process_time_start 处理时间-开始 
     * @support  string $process_time_end 处理时间-结束 
     * @support  string $complete_time_start 退款完成时间-开始 
     * @support  string $complete_time_end 退款完成时间-结束 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款处理
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 退款申请并处理
     *
     * @support  int $sub_order_id 子订单id [ require true ]
     * @support  string $refund_type 退款类型 
     * @support  string $channel 退款通道 
     * @support  array $refund_item 退款项 
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  array $reason_ids 退款ids [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @support  int $input_staff_id 退款申请人工号 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function createAndConfirm () {
        return self::getClass()->createAndConfirm();
    }

    /**
     * 对待确认的错误退款进行修正
     *
     * @param  int $id 退款ID [ require true ]
     * @param  float $auto_real_money 自动退款金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fixDubiousRefundResult (int $id, float $auto_real_money) {
        return self::getClass()->fixDubiousRefundResult([
            "id" => $id,
            "auto_real_money" => $auto_real_money,
        ]);
    }

    /**
     * 支持修改收款人姓名、收款人账户（支付宝账户）不填则不修改
     *
     * @support  int $id 退款ID [ require true ]
     * @support  string $people 退款人 
     * @support  string $account 退款账户 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixRefundAccount () {
        return self::getClass()->fixRefundAccount();
    }

    /**
     * 退款详情
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 拒绝退款
     *
     * @support  int $id 退款id [ require true ]
     * @support  string $reason 拒绝理由 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuse () {
        return self::getClass()->refuse();
    }

    /**
     * 退款理由
     *
     * @support  string $category 分类：category_user_refund,category_admin_refund 
     * @support  int $parent_id  
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * 快速退款至礼品卡
     *
     * @support  int $sub_order_id 子订单id [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fastRefundToGiftCard () {
        return self::getClass()->fastRefundToGiftCard();
    }

    /**
     * 根据子订单ID获取子订单项退款信息
     *
     * @support  int $sub_order_id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function subOrderRefundStatus () {
        return self::getClass()->subOrderRefundStatus();
    }

    /**
     * 获取部分子订单项可退金额
     *
     * @support  int $sub_order_id 子订单ID [ require true ]
     * @support  array $refund_item 子订单项 [ require true ]
     * @support  array $detail 产品详情 
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundDetailByIds () {
        return self::getClass()->canRefundDetailByIds();
    }

    /**
     * 换产品（单个产品）
     *
     * @support  int $sub_order_id 子订单ID [ require true ]
     * @support  int $refund_item_id 退款产品id 
     * @support  array $refund_item_ids 退款产品ids 
     * @support  int $input_staff_id 主推人id 
     * @support  array $detail 产品详情 [ require true ]
     * @support  string $pay_type 支付方式 
     * @support  float $real_money 手动输入支付金额 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProduct () {
        return self::getClass()->changeProduct();
    }

    /**
     * 签证/同类互换
     *
     * @support  int $sub_order_id 子订单号 [ require true ]
     * @support  int $input_staff_id 录入人伙伴ID 
     * @support  array $detail 产品详情 [ require true ]
     * @support  int $refund_item_id 退款项id [ require true ]
     * @support  int $service_id 退款项服务id [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function visaChange () {
        return self::getClass()->visaChange();
    }

    /**
     * 手动退款再次确认
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function confirmHandRefund (int $id) {
        return self::getClass()->confirmHandRefund([
            "id" => $id,
        ]);
    }

    /**
     * 创建伙伴垫付申请记录
     *
     * @param  int $staffId 伙伴工号 [ require true ]
     * @param  array $refundInfo 退款信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffPay (int $staffId, array $refundInfo) {
        return self::getClass()->createStaffPay([
            "staffId" => $staffId,
            "refundInfo" => $refundInfo,
        ]);
    }

    /**
     * 确认伙伴垫付退款
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $subOrderId 自订单id [ require true ]
     * @param  int $userId userId [ require true ]
     * @param  bool $isStaffPay 是否伙伴垫付 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmStaffPay (int $userId, int $subOrderId, string $orderNo, bool $isStaffPay) {
        return self::getClass()->confirmStaffPay([
            "userId" => $userId,
            "subOrderId" => $subOrderId,
            "orderNo" => $orderNo,
            "isStaffPay" => $isStaffPay,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}