<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Tmp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQuestionByParams(array $params)
 * @method getMedalNumByParams(array $params)
 * @method answerQuestionByParams(array $params)
 * @method drawAwardByParams(array $params)
 * @method sendAwardByParams(array $params)
 * @method sendNoticeByParams(array $params)
 */
class JiGuangActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取问题
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQuestion (int $staffId) {
        return self::getClass()->getQuestion([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取奖章数
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedalNum (int $staffId) {
        return self::getClass()->getMedalNum([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 回答问题
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $answer 答案 [ require true ]
     * @param  int $key 序号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function answerQuestion (int $staffId, string $answer, int $key) {
        return self::getClass()->answerQuestion([
            "staffId" => $staffId,
            "answer" => $answer,
            "key" => $key,
        ]);
    }

    /**
     * 抽奖
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function drawAward (int $staffId) {
        return self::getClass()->drawAward([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 2021-01-01 00:00:00开奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAward () {
        return self::getClass()->sendAward();
    }

    /**
     * 每周五推送极光之星活动消息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Tmp\JiGuangActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}