<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createCouponByParams(array $params)
 * @method getTokenByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建衣邦人兑换码
     *
     * @param  string $name 商户名 [ require true ]
     * @param  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCoupon (string $name = '', string $token = '') {
        return self::getClass()->createCoupon([
            "name" => $name,
            "token" => $token,
        ]);
    }

    /**
     * 获取token值
     *
     * @param  string $appId appId [ require true ]
     * @param  string $appSecret appSecret [ require true ]
     * @param  string $name 商户名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken (string $appId = '', string $appSecret = '', string $name = '') {
        return self::getClass()->getToken([
            "appId" => $appId,
            "appSecret" => $appSecret,
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}