<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 */
class OtherOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建其它订单退款
     *
     * @support  string $order_no 订单号 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  float $money 退款金额 [Original type double] [ require true ]
     * @support  string $type 类型 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取其它订单退款列表
     *
     * @support  int $page  
     * @support  int $page_size  
     * @support  string $order_no 订单号 
     * @support  string $brand 品牌 
     * @support  int $store_id 门店ID 
     * @support  array $store_ids 门店ID 
     * @support  string $status 状态 
     * @support  string $type 类型 
     * @support  string $created_at_start 创建时间-开始 
     * @support  string $created_at_end 创建时间-结束 
     * @support  string $passed_at_start 通过时间-开始 
     * @support  string $passed_at_end 通过时间-结束 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取其它订单退款详情
     *
     * @support  int $id 退款id 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 通过其它订单退款申请
     *
     * @support  int $id 退款id 
     * @throws  \Exception
     * @return  array
     */
    public static function pass () {
        return self::getClass()->pass();
    }

    /**
     * 拒绝过其它订单退款申请
     *
     * @support  int $id 退款id 
     * @throws  \Exception
     * @return  array
     */
    public static function reject () {
        return self::getClass()->reject();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OtherOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OtherOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}