<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method availableListByParams(array $params)
 * @method bindByParams(array $params)
 * @method getUserObtainPreferentialRecordByParams(array $params)
 * @method springCouponInfoByParams(array $params)
 * @method springCouponByParams(array $params)
 */
class PreferentialCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户已有的优惠券
     *
     * @support  string $status 优惠券状态 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取用户下单可用优惠券(含未失效但不可用)
     *
     * @support  array $product_ids 产品ids 
     * @support  int $store_id 门店id [Original type uint] [ require true ]
     * @support  array $product_group_ids 产品组ids 
     * @throws  \Exception
     * @return  array
     */
    public static function availableList () {
        return self::getClass()->availableList();
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $preferential_code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 获取用户领券记录
     *
     * @support  int $user_id user_id [ require true ]
     * @support  string $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserObtainPreferentialRecord () {
        return self::getClass()->getUserObtainPreferentialRecord();
    }

    /**
     * 春暖花开优惠券领取信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function springCouponInfo () {
        return self::getClass()->springCouponInfo();
    }

    /**
     * 领取春暖花开优惠券
     *
     * @support  int $index 产品下标 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function springCoupon () {
        return self::getClass()->springCoupon();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\PreferentialCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\PreferentialCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}