<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cityByParams(array $params)
 * @method productStoreByParams(array $params)
 * @method productReservationStoreByParams(array $params)
 * @method payWayByParams(array $params)
 * @method getMostNearestStoreByParams(array $params)
 * @method hasProductStoresByParams(array $params)
 * @method getStoreinfoByParams(array $params)
 * @method searchStoreByDataByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取有门店的所有城市
     *
     * @support  array $store_type 门店类型 
     * @throws  \Exception
     * @return  array
     */
    public static function city () {
        return self::getClass()->city();
    }

    /**
     * 获取有该产品的门店
     *
     * @support  array $node_ids 产品id [ require true ]
     * @support  array $store_ids 门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productStore () {
        return self::getClass()->productStore();
    }

    /**
     * 获取有该产品的门店
     *
     * @support  string $date 预约日期 [ require true ]
     * @support  array $product_group 产品数组 [ require true ]
     * @support  array $store_ids 门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productReservationStore () {
        return self::getClass()->productReservationStore();
    }

    /**
     * 获取某家门店绑定的支付类型
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function payWay (int $store_id) {
        return self::getClass()->payWay([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取距离最近的门店
     *
     * @param  array $location 地理位置,[125,30] [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMostNearestStore (array $location, string $brand) {
        return self::getClass()->getMostNearestStore([
            "location" => $location,
            "brand" => $brand,
        ]);
    }

    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     *
     * @support  int $node_id 产品id或者Category id [Original type uint] [ require true ]
     * @support  string $type 查询类型 [ require true ]
     * @support  int $city_id 城市id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hasProductStores () {
        return self::getClass()->hasProductStores();
    }

    /**
     * 获取某个门店的详情
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreinfo () {
        return self::getClass()->getStoreinfo();
    }

    /**
     * 获取指定条件下的所有门店 经刀锋确认要废弃
     *
     * @param  int $city_id 城市的ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchStoreByData (int $city_id) {
        return self::getClass()->searchStoreByData([
            "city_id" => $city_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}