<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateIsInactiveByParams(array $params)
 * @method updateIsMainByParams(array $params)
 * @method categoryTreeByParams(array $params)
 * @method setCategoryBuyerByParams(array $params)
 * @method setStockBuyerByParams(array $params)
 * @method getStockBuyerByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新信息
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  array $buyerIds 采购员工号 
     * @support  int $cycle 配发周期 [Original type uint] 
     * @support  int $adjustMax 调整上限 [Original type uint] 
     * @support  int $adjustMin 调整下限 [Original type uint] 
     * @support  array $safetyCount 安全库存 
     * @support  array $skuInfo sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 更新是否非活动
     *
     * @param  int $skuId 物料skuid [Original type uint] [ require true ]
     * @param  int $isInactive 是否无效,1无效/0有效 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateIsInactive (int $skuId, int $isInactive) {
        return self::getClass()->updateIsInactive([
            "skuId" => $skuId,
            "isInactive" => $isInactive,
        ]);
    }

    /**
     * 更新是否主配
     *
     * @param  int $skuId 物料skuid [Original type uint] [ require true ]
     * @param  int $isMain 是否主配,1是/0否 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateIsMain (int $skuId, int $isMain) {
        return self::getClass()->updateIsMain([
            "skuId" => $skuId,
            "isMain" => $isMain,
        ]);
    }

    /**
     * 分类树
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function categoryTree () {
        return self::getClass()->categoryTree();
    }

    /**
     * 设置分类采购员
     *
     * @param  array $buyerInfo 采购员信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCategoryBuyer (array $buyerInfo) {
        return self::getClass()->setCategoryBuyer([
            "buyerInfo" => $buyerInfo,
        ]);
    }

    /**
     * 设置总仓采购员
     *
     * @param  array $buyers 采购员信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockBuyer (array $buyers = []) {
        return self::getClass()->setStockBuyer([
            "buyers" => $buyers,
        ]);
    }

    /**
     * 设置总仓采购员
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockBuyer () {
        return self::getClass()->getStockBuyer();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}