<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 */
class Specification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建规格
     *
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $type, string $code = '') {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
            "code" => $code,
        ]);
    }

    /**
     * 修改规格
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  int $updateBy 创建人工号 [Original type uint] 
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, string $type, string $code = '') {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "type" => $type,
            "code" => $code,
        ]);
    }

    /**
     * 批量修改
     *
     * @param  string $type 类型 [ require true ]
     * @param  array $info 规格信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (string $type, array $info) {
        return self::getClass()->batchUpdate([
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 规格列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除规格
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 所有规格[不分页]
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Specification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Specification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}