<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method batchUpProductByParams(array $params)
 * @method batchDownProductByParams(array $params)
 * @method setSellPriceByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method getProductStoreGroupByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method allByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 * @method detailByParams(array $params)
 * @method getStoreGroupListByParams(array $params)
 * @method createStoreGroupByParams(array $params)
 * @method editStoreGroupByParams(array $params)
 * @method removeStoreGroupByParams(array $params)
 * @method groupBindStoreByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 * @method getSkuNameListByParams(array $params)
 * @method getLabelListByParams(array $params)
 * @method updateSortByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $skus 商品skus [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑零售产品
     *
     * @support  int $id 产品ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $brandId 分类ID [Original type uint] [ require true ]
     * @support  array $categoryAttrs 产品主图 
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  int $brandId 品牌ID [Original type uint] 
     * @support  string $status 状态 
     * @support  string $startAt 创建时间 
     * @support  int $onlineSales 预约端1/0 [Original type uint] 
     * @support  int $offlineSales 门店端1/0 [Original type uint] 
     * @support  string $endAt 更新时间 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 页内条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 批量上架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpProduct (array $ids) {
        return self::getClass()->batchUpProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDownProduct (array $ids) {
        return self::getClass()->batchDownProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 配置sku的现价/售价
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSellPrice (array $data) {
        return self::getClass()->setSellPrice([
            "data" => $data,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTags (int $id, array $tags) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 获取商品门店组信息
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductStoreGroup (int $id) {
        return self::getClass()->getProductStoreGroup([
            "id" => $id,
        ]);
    }

    /**
     * 设置商品门店组信息
     *
     * @param  array $ids 产品ids [ require true ]
     * @param  array $storeGroupIds 门店组ids [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $product_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByCode (string $product_code) {
        return self::getClass()->getDetailByCode([
            "product_code" => $product_code,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取城市组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreGroupList () {
        return self::getClass()->getStoreGroupList();
    }

    /**
     * 创建城市组
     *
     * @support  string $name 分组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStoreGroup () {
        return self::getClass()->createStoreGroup();
    }

    /**
     * 修改城市组名
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStoreGroup () {
        return self::getClass()->editStoreGroup();
    }

    /**
     * 删除城市组
     *
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreGroup () {
        return self::getClass()->removeStoreGroup();
    }

    /**
     * 城市组绑定店铺
     *
     * @support  int $id 城市组id [ require true ]
     * @support  string $name 城市组名称 [ require true ]
     * @support  array $storeIds 门店组 
     * @support  array $ruleInfo 规则详情。moduleName: himo_blue,himo_gold,himo_kids,mainto 
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupBindStore () {
        return self::getClass()->groupBindStore();
    }

    /**
     * 获取城市组详情
     *
     * @param  int $id 城市组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail (int $id) {
        return self::getClass()->getGroupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取规格名列表
     *
     * @support  string $name 规格名 
     * @support  bool $withLabel 是否需要规格值 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuNameList () {
        return self::getClass()->getSkuNameList();
    }

    /**
     * 获取规格值列表
     *
     * @support  string $name 规格值名称 
     * @support  int $groupId 规格名id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLabelList () {
        return self::getClass()->getLabelList();
    }

    /**
     * 更改排序
     *
     * @param  int $id 品类id [Original type uint] [ require true ]
     * @param  int $sort 排序值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSort (int $id, int $sort) {
        return self::getClass()->updateSort([
            "id" => $id,
            "sort" => $sort,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}