<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method batchRemoveByParams(array $params)
 * @method allByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method getPropertiesByIdByParams(array $params)
 * @method batchCreateCategoryByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品品类
     *
     * @param  string $name 类目名称 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @param  int $parentId 父级类目id [Original type uint] [ require true ]
     * @param  array $property 属性 [ require true ]
     * @param  array $lifecycle 生命周期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $code = '', int $parentId = 0, array $property = [], array $lifecycle = []) {
        return self::getClass()->create([
            "name" => $name,
            "code" => $code,
            "parentId" => $parentId,
            "property" => $property,
            "lifecycle" => $lifecycle,
        ]);
    }

    /**
     * 编辑零售产品品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @param  string $name 类目名称 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @param  int $sort 排序值 [Original type uint] [ require true ]
     * @param  array $property 属性 [ require true ]
     * @param  array $lifecycle 生命周期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name, string $code = '', int $sort = 0, array $property = [], array $lifecycle = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "code" => $code,
            "sort" => $sort,
            "property" => $property,
            "lifecycle" => $lifecycle,
        ]);
    }

    /**
     * 批量编辑零售产品品类
     *
     * @param  array $data 品类数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data) {
        return self::getClass()->batchCreate([
            "data" => $data,
        ]);
    }

    /**
     * 批量编辑零售产品品类
     *
     * @param  array $data 品类数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 品类详情
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 类目IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchRemove (array $ids) {
        return self::getClass()->batchRemove([
            "ids" => $ids,
        ]);
    }

    /**
     * 所有品类信息
     * @deprecated
     *
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (bool $showDeleted = false) {
        return self::getClass()->all([
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 添加品类时获取类目N级树状列表/获取树状列表
     *
     * @param  int $parentId 父级id [ require true ]
     * @param  int $depth 深度,代表几级分类 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return self::getClass()->getCategoryTree([
            "parentId" => $parentId,
            "depth" => $depth,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 根据品类id获取属性信息
     *
     * @param  int $id 品类id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPropertiesById (int $id) {
        return self::getClass()->getPropertiesById([
            "id" => $id,
        ]);
    }

    /**
     * 批量导入品类
     *
     * @param  array $info 商品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreateCategory (array $info) {
        return self::getClass()->batchCreateCategory([
            "info" => $info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}