<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method globalSearchByParams(array $params)
 * @method detailByParams(array $params)
 * @method cloudOrderDetailByParams(array $params)
 * @method changeNoteByParams(array $params)
 * @method createByParams(array $params)
 * @method userReachedByParams(array $params)
 * @method modifyUserReachedByParams(array $params)
 * @method setUserReachedPaidByParams(array $params)
 * @method getUserReachedDetailByParams(array $params)
 * @method createOldByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method updateUserByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method closeByParams(array $params)
 * @method setOrderClosedByRefundByParams(array $params)
 * @method startByParams(array $params)
 * @method finishByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method removeByParams(array $params)
 * @method getCanUseCouponListByParams(array $params)
 * @method getCanUseProductCardListByParams(array $params)
 * @method calCouponDeductionInfoByParams(array $params)
 * @method calProductDeductionInfoByParams(array $params)
 * @method calInteriorCouponDeductionInfoByParams(array $params)
 * @method operateLogByParams(array $params)
 * @method reserveProductCountByParams(array $params)
 * @method getEncryptOrderNumByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendPayLinkByParams(array $params)
 * @method orderCountByParams(array $params)
 * @method setOrderCountByParams(array $params)
 * @method orderClothByParams(array $params)
 * @method updateOrderClothByParams(array $params)
 * @method itemOrderClothByParams(array $params)
 * @method yuanYangCodeByParams(array $params)
 * @method partRefundNoteByParams(array $params)
 * @method useGiftCardMoneyByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method listByPayByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表查询
     *
     * @support  string $orderNo 订单号 
     * @support  string $reserveTimeStart 预约开始时间 
     * @support  string $reserveTimeEnd 预约结束时间 
     * @support  string $createTimeStart 查询开始时间 
     * @support  string $createTimeEnd 查询结束时间 
     * @support  string $status 订单状态 
     * @support  string $statusList 订单状态 
     * @support  string $module 模块 
     * @support  string $userName 下单用户 
     * @support  string $userPhone 手机号 
     * @support  int $userId 用户id 
     * @support  bool $allStore 是否查询所有门店 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 全局订单列表查询
     *
     * @support  string $orderNo 订单号 
     * @support  string $userName 下单用户 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  bool $withDel 是否需要删除数据 
     * @throws  \Exception
     * @return  array
     */
    public static function globalSearch () {
        return self::getClass()->globalSearch();
    }

    /**
     * 获取订单详情
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $orderNo 订单号 [ require true ]
     * @support  bool $withDelete 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 云端订单详情
     *
     * @support  string $order_no 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cloudOrderDetail () {
        return self::getClass()->cloudOrderDetail();
    }

    /**
     * 修改订单备注
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeNote () {
        return self::getClass()->changeNote();
    }

    /**
     * 创建订单
     *
     * @support  int $userId 用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  int $reachedPeopleNum 实际到店人数 [ require true ]
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 设置拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） [Original type double] 
     * @throws  \Exception
     * @return  array
     */
    public static function userReached () {
        return self::getClass()->userReached();
    }

    /**
     * 修改拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） [Original type double] 
     * @throws  \Exception
     * @return  array
     */
    public static function modifyUserReached () {
        return self::getClass()->modifyUserReached();
    }

    /**
     * 设置签到完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 
     * @support  int $operateId 录单人 
     * @support  bool $fromPaymentGateway 来自支付网关 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserReachedPaid () {
        return self::getClass()->setUserReachedPaid();
    }

    /**
     * 如果没有数据，说明没有支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserReachedDetail (int $orderId) {
        return self::getClass()->getUserReachedDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 创建订单（管理端开单）
     *
     * @support  int $user_id 用户ID 
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  int $occupy_num 排单表占点数量 [ require true ]
     * @support  array $detail 订单详情（商品&amp;服务详情） [ require true ]
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  string $module 模块 
     * @support  float $coupon_deduction_money 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $product_card_deduction_money 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $product_discount_ids 组合优惠id 
     * @support  float $product_discount_deduction_money 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  string $interior_coupon_code 开单折扣码 
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 
     * @support  string $discount_scene 改价选项 
     * @support  int $partner_no 伙伴工号（伙伴改价场景需要） 
     * @support  float $input_real_money 手动输入的实际价格（改价时需要） [Original type double] 
     * @support  string $create_mode 订单创建模式 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOld () {
        return self::getClass()->createOld();
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单所属用户
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  string $phone 新绑定用户的手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUser () {
        return self::getClass()->updateUser();
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, int $orderDiffId, string $payType, string $paymentNo = '') {
        return self::getClass()->paid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 把订单设置为退款关闭【只更改主订单状态】
     *
     * @support  string $order_no 订单ID [ require true ]
     * @support  string $closed_at 退款关闭时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderClosedByRefund () {
        return self::getClass()->setOrderClosedByRefund();
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单（拍摄完成）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id, array $workloads) {
        return self::getClass()->finish([
            "id" => $id,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 拍摄完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverFinishedToWaitShooting (int $id) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $user_name 用户姓名 [ require true ]
     * @param  string $user_sex 用户性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData (int $id, string $user_name, string $user_sex) {
        return self::getClass()->changeUserData([
            "id" => $id,
            "user_name" => $user_name,
            "user_sex" => $user_sex,
        ]);
    }

    /**
     * 转门店
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $storeId, string $reserveTime) {
        return self::getClass()->changeStore([
            "id" => $id,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 用户可用优惠券列表
     *
     * @support  array $product_group_ids 产品组ids 
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids 
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $apply_in 应用于 
     * @support  int $order_id 订单id(用于查找当前订单已用券) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanUseCouponList () {
        return self::getClass()->getCanUseCouponList();
    }

    /**
     * 用户可用产品卡列表
     *
     * @support  array $product_group_ids 产品组ids 
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids 
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $apply_in 应用于 
     * @support  int $order_id 订单id(用于查找当前订单已用券) 
     * @throws  \Exception
     * @return  array
     */
    public static function getCanUseProductCardList () {
        return self::getClass()->getCanUseProductCardList();
    }

    /**
     * 计算优惠券可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $coupon_id 优惠券ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calCouponDeductionInfo () {
        return self::getClass()->calCouponDeductionInfo();
    }

    /**
     * 计算产品卡可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $product_card_id 产品卡ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calProductDeductionInfo () {
        return self::getClass()->calProductDeductionInfo();
    }

    /**
     * 订单开单折扣码抵扣
     *
     * @support  string $interior_coupon_code 开单折扣码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calInteriorCouponDeductionInfo () {
        return self::getClass()->calInteriorCouponDeductionInfo();
    }

    /**
     * 管理端查询订单操作记录
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operateLog (int $order_id) {
        return self::getClass()->operateLog([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取当日售卖产品总数
     *
     * @support  string $reserveTimeStart 起始时间 
     * @support  string $reserveTimeEnd 结束时间 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function reserveProductCount () {
        return self::getClass()->reserveProductCount();
    }

    /**
     * 获取加密订单号
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getEncryptOrderNum (string $order_num) {
        return self::getClass()->getEncryptOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $url 付款链接前缀 [ require true ]
     * @param  string $pay_type 类型(首款或者尾款) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type = '') {
        return self::getClass()->getShortUrl([
            "order_num" => $order_num,
            "url" => $url,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 发送付款链接
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $url 付款链接 [ require true ]
     * @param  string $phone 电话号码 [ require true ]
     * @param  string $orderType 订单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPayLink (int $orderId, string $url, string $orderType, string $phone) {
        return self::getClass()->sendPayLink([
            "orderId" => $orderId,
            "url" => $url,
            "orderType" => $orderType,
            "phone" => $phone,
        ]);
    }

    /**
     * 某日的非圣诞照数量
     *
     * @param  string $date 时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderCount (string $date) {
        return self::getClass()->orderCount([
            "date" => $date,
        ]);
    }

    /**
     * 设置某日的非圣诞照数量
     *
     * @param  string $date 时间 [ require true ]
     * @param  int $count 个数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderCount (string $date, int $count) {
        return self::getClass()->setOrderCount([
            "date" => $date,
            "count" => $count,
        ]);
    }

    /**
     * 获取订单预选服装
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderCloth (int $order_id) {
        return self::getClass()->orderCloth([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 门店最终选衣
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  int $item_id 子订单itemid [Original type uint] [ require true ]
     * @param  array $final_cloth 最终选衣 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderCloth (int $order_id, int $item_id, array $final_cloth = []) {
        return self::getClass()->updateOrderCloth([
            "order_id" => $order_id,
            "item_id" => $item_id,
            "final_cloth" => $final_cloth,
        ]);
    }

    /**
     * 门店换产品处理选衣
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  int $item_id 子订单itemid [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemOrderCloth (int $order_id, int $item_id = 0) {
        return self::getClass()->itemOrderCloth([
            "order_id" => $order_id,
            "item_id" => $item_id,
        ]);
    }

    /**
     * 查询鸳鸯照码的发送情况
     *
     * @support  int $limit 条数限制 [Original type uint] 
     * @support  string $order_no 订单号 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function yuanYangCode () {
        return self::getClass()->yuanYangCode();
    }

    /**
     * 退款订单备注
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  float $money 状态 [Original type unsignedDouble] [ require true ]
     * @support  int $type 类型 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function partRefundNote () {
        return self::getClass()->partRefundNote();
    }

    /**
     * 修改使用礼品卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoney () {
        return self::getClass()->useGiftCardMoney();
    }

    /**
     * 修改使用商场卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $marketCardMoney 商场卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney () {
        return self::getClass()->useMarketCardMoney();
    }

    /**
     * 使用礼品卡支付确认的推送
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return self::getClass()->sendGiftCardPayDsConfirmPush([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 查账助手-根据订单类型获取
     *
     * @support  string $orderType 订单类型 
     * @support  string $type 子订单类型：order,ds 
     * @support  string $status 状态 
     * @support  string $statusList 状态列表 
     * @support  string $payType 支付类型，同子订单支付类型 
     * @support  string $paidAtStart 支付时间起始 [ require true ]
     * @support  string $paidAtEnd 支付时间结束 [ require true ]
     * @support  string $pageSize  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPay () {
        return self::getClass()->listByPay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}