<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getMaterialInfoByParams(array $params)
 * @method createAliasByParams(array $params)
 * @method removeAliasByParams(array $params)
 * @method getSkuNameListByParams(array $params)
 * @method getLabelListByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailBySkuByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method batchUpProductByParams(array $params)
 * @method batchDownProductByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 * @method getStoreGroupListByParams(array $params)
 * @method createStoreGroupByParams(array $params)
 * @method editStoreGroupByParams(array $params)
 * @method removeStoreGroupByParams(array $params)
 * @method groupBindStoreByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [Original type uint] [ require true ]
     * @support  string $main_img 产品主图地址 
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @support  array $store_group 城市组 
     * @support  int $online_sales 线上销售:1 是 0 否 [ require true ]
     * @support  int $offline_sales 线下销售 [ require true ]
     * @support  int $alias_id 别名id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取物料信息
     *
     * @support  string $name 物料名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialInfo () {
        return self::getClass()->getMaterialInfo();
    }

    /**
     * 添加产品别名
     *
     * @support  string $name 别名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAlias () {
        return self::getClass()->createAlias();
    }

    /**
     * 删除产品别名
     *
     * @support  int $id 别名id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeAlias () {
        return self::getClass()->removeAlias();
    }

    /**
     * 获取规格名列表
     *
     * @support  string $name 规格名 
     * @support  bool $withLabel 是否需要规格值 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuNameList () {
        return self::getClass()->getSkuNameList();
    }

    /**
     * 获取规格值列表
     *
     * @support  string $name 规格值名称 
     * @support  int $groupId 规格名id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLabelList () {
        return self::getClass()->getLabelList();
    }

    /**
     * 编辑零售产品
     *
     * @support  int $id 产品ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [Original type uint] [ require true ]
     * @support  string $main_img 产品主图地址 
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @support  int $sku_id sku id 
     * @support  array $store_group 城市组 
     * @support  int $online_sales 线上销售:1 是 0 否 [ require true ]
     * @support  int $offline_sales 线下销售 [ require true ]
     * @support  int $alias_id 别名id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据sku获取产品详情
     *
     * @param  int $id sku id [Original type uint] [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailBySku (int $id, bool $withOffSku = false) {
        return self::getClass()->detailBySku([
            "id" => $id,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 批量产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 批量上架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpProduct (array $ids) {
        return self::getClass()->batchUpProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDownProduct (array $ids) {
        return self::getClass()->batchDownProduct([
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  int $online_sales 线上1, 否则0 [Original type uint] 
     * @support  int $offline_sales 线下1, 否则0 [Original type uint] 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $product_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByCode (string $product_code) {
        return self::getClass()->getDetailByCode([
            "product_code" => $product_code,
        ]);
    }

    /**
     * 获取城市组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreGroupList () {
        return self::getClass()->getStoreGroupList();
    }

    /**
     * 创建城市组
     *
     * @support  string $name 分组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStoreGroup () {
        return self::getClass()->createStoreGroup();
    }

    /**
     * 修改城市组名
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStoreGroup () {
        return self::getClass()->editStoreGroup();
    }

    /**
     * 删除城市组
     *
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreGroup () {
        return self::getClass()->removeStoreGroup();
    }

    /**
     * 城市组绑定店铺
     *
     * @support  int $id 城市组id [ require true ]
     * @support  string $name 城市组名称 [ require true ]
     * @support  array $storeIds 门店组 
     * @support  array $ruleInfo 规则详情。moduleName: himo_blue,himo_gold,himo_kids,mainto 
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupBindStore () {
        return self::getClass()->groupBindStore();
    }

    /**
     * 获取城市组详情
     *
     * @param  int $id 城市组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail (int $id) {
        return self::getClass()->getGroupDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}