<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method onlineCustomerPhotoByParams(array $params)
 * @method offlineCustomerPhotoByParams(array $params)
 * @method updateSortByParams(array $params)
 * @method getUploadStaffByParams(array $params)
 */
class MantuCustomerPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交客片
     *
     * @support  int $productId 产品id [ require true ]
     * @support  string $productName 产品名 [ require true ]
     * @support  string $photoName 客片名称 [ require true ]
     * @support  string $productCategory 产品类别 [ require true ]
     * @support  array $paths 客片url数组 [ require true ]
     * @support  string $certificatePath 凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 客片列表
     *
     * @support  int $productId 产品id 
     * @support  string $name 客片名称 
     * @support  string $status 客片状态 
     * @support  int $uploadStaff 上传人 
     * @support  string $productCategory 产品类别 
     * @support  string $createdAtStart 查询开始时间 
     * @support  string $createdAtEnd 查询结束时间 
     * @support  int $pageSize 单页数量 
     * @support  int $page 页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 上架客片
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineCustomerPhoto () {
        return self::getClass()->onlineCustomerPhoto();
    }

    /**
     * 下架客片
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineCustomerPhoto () {
        return self::getClass()->offlineCustomerPhoto();
    }

    /**
     * 调整排序
     *
     * @support  int $sort 排序 [ require true ]
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSort () {
        return self::getClass()->updateSort();
    }

    /**
     * 获取全部上传人
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUploadStaff () {
        return self::getClass()->getUploadStaff();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MantuCustomerPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MantuCustomerPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}