<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInventoriesByParams(array $params)
 * @method getInventoryByParams(array $params)
 * @method exportInventoryByParams(array $params)
 */
class RetailInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取盘点数据记录
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $subjectId 子公司id [Original type uint] 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $staffId 员工id [Original type uint] 
     * @param  string $applyIn 总部/门店 [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventories (string $applyIn, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getInventories([
            "applyIn" => $applyIn,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取盘点记录详情
     *
     * @param  int $id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventory (int $id) {
        return self::getClass()->getInventory([
            "id" => $id,
        ]);
    }

    /**
     * 盘点导出
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $staffId 员工id [Original type uint] 
     * @param  string $applyIn 总部/门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportInventory (string $applyIn = 'store') {
        return self::getClass()->exportInventory([
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\RetailInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\RetailInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}