<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 */
class ThirdGroupBind {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  int $group_id 团购ID 
     * @support  string $brand 品牌 
     * @support  string $type 第三方来源 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $page_size = 20) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 创建
     *
     * @support  string $type 第三方来源 
     * @support  string $brand 品牌 [ require true ]
     * @support  string $group_id 团购ID [ require true ]
     * @support  string $group_name 团购名称 [ require true ]
     * @support  int $group_product_num 团购绑定产品个数 [ require true ]
     * @support  array $bind_products 绑定的产品 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新
     *
     * @support  int $id 团购绑定ID 
     * @support  string $type 第三方来源 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  string $group_id 团购ID [ require true ]
     * @support  string $group_name 团购名称 [ require true ]
     * @support  int $group_product_num 团购绑定产品个数 [ require true ]
     * @support  array $bind_products 绑定的产品 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 详情
     *
     * @support  int $id 绑定ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 删除
     *
     * @support  int $id 绑定ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ThirdGroupBind');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ThirdGroupBind');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}