<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInventoriesByParams(array $params)
 * @method getInventoryByParams(array $params)
 * @method exportInventoryByParams(array $params)
 */
class RetailInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取盘点数据记录
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  array $storeIds 门店id 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventories (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getInventories([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取盘点记录详情
     *
     * @param  int $id 盘点id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventory (int $id, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getInventory([
            "id" => $id,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点导出
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  array $storeIds 门店id 
     * @throws  \Exception
     * @return  array
     */
    public static function exportInventory () {
        return self::getClass()->exportInventory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\RetailInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\RetailInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}