<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method batchRemoveByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method getCategoryForActivityByParams(array $params)
 */
class RetailCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品品类
     *
     * @param  string $name 品类名称 [ require true ]
     * @param  int $parentId 品类父级ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, int $parentId = 0) {
        return self::getClass()->create([
            "name" => $name,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 编辑零售产品品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @param  string $name 品类名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 批量编辑零售产品品类
     *
     * @param  array $data 品类数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 品类详情
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 类目IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchRemove (array $ids) {
        return self::getClass()->batchRemove([
            "ids" => $ids,
        ]);
    }

    /**
     * 品类分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 品类列表
     * @deprecated
     *
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (bool $show_deleted = false) {
        return self::getClass()->all([
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 添加品类时获取类目N级树状列表/获取树状列表
     *
     * @param  bool $withProducts 是否带产品信息 [ require true ]
     * @param  int $parentId 父级id [ require true ]
     * @param  int $depth 深度,代表几级分类 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  string $scene 使用场景,create筛选当前门店,show展示全部 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (bool $withProducts = true, int $parentId = 0, int $depth = 0, bool $showDeleted = false, string $scene = '') {
        return self::getClass()->getCategoryTree([
            "withProducts" => $withProducts,
            "parentId" => $parentId,
            "depth" => $depth,
            "showDeleted" => $showDeleted,
            "scene" => $scene,
        ]);
    }

    /**
     * 活动页面获取类目列表
     *
     * @support  bool $withProducts 是否带产品信息 
     * @support  int $parentId 父级id 
     * @support  int $depth 深度,代表几级分类 
     * @support  string $type 活动类型 
     * @support  int $promotion_id 活动id 
     * @support  string $sku_type 商品类型 
     * @support  bool $showDeleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryForActivity () {
        return self::getClass()->getCategoryForActivity();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}