<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method myPhotoAlbumByParams(array $params)
 * @method createSharePhotoDataByParams(array $params)
 * @method updateSharePhotoDataByParams(array $params)
 * @method shareRecordDetailByParams(array $params)
 * @method downSharePhotoDataByParams(array $params)
 */
class PhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的相册
     *
     * @support  int $page 页码 [ require true ]
     * @support  int $page_size 分页数 [ require true ]
     * @support  string $last_order_reserve_time 上一页最后预约时间 
     * @throws  \Exception
     * @return  array
     */
    public static function myPhotoAlbum () {
        return self::getClass()->myPhotoAlbum();
    }

    /**
     * 创建相册分享记录
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  array $photos 分享的图片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSharePhotoData () {
        return self::getClass()->createSharePhotoData();
    }

    /**
     * 更新分享记录信息
     *
     * @support  int $share_type 分享类型 1:普通共享 2:指定共享 [ require true ]
     * @support  array $white_phones 指定共享的手机号 
     * @support  string $share_record_id 待更新的分享记录id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSharePhotoData () {
        return self::getClass()->updateSharePhotoData();
    }

    /**
     * 分享记录详情
     *
     * @support  string $share_record_id 分享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shareRecordDetail () {
        return self::getClass()->shareRecordDetail();
    }

    /**
     * 下载分享数据到我的相册
     *
     * @support  string $share_record_id 分享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downSharePhotoData () {
        return self::getClass()->downSharePhotoData();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\PhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\PhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}