<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderClothByParams(array $params)
 * @method myChooseClothByParams(array $params)
 * @method chooseClothByParams(array $params)
 */
class OrderCloth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单拍前衣服
     *
     * @param  string $order_no 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderCloth (string $order_no) {
        return self::getClass()->orderCloth([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 获取我的选衣图片
     *
     * @support  string $order_no 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function myChooseCloth () {
        return self::getClass()->myChooseCloth();
    }

    /**
     * 提交选择的照片
     *
     * @support  string $order_no 订单编号 [ require true ]
     * @support  array $clothes 图片数组 [ require true ]
     * @support  string $upper 上衣 
     * @support  string $lower 下装 
     * @support  string $career 职业 
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseCloth () {
        return self::getClass()->chooseCloth();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\OrderCloth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\OrderCloth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}