<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method historyByParams(array $params)
 * @method createSimpleByParams(array $params)
 * @method listByParams(array $params)
 * @method hmxStoreByParams(array $params)
 */
class ElectronicInvoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取发票列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function history () {
        return self::getClass()->history();
    }

    /**
     * 开普票
     *
     * @support  string $code 短信验证码 [ require true ]
     * @support  array $order_nums 订单号 [ require true ]
     * @support  string $service_type 服务类型 [ require true ]
     * @support  int $is_now 是否立即开具电子发票 [ require true ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机 
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $message 备注信息 
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $email 推送邮箱 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方单位地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSimple () {
        return self::getClass()->createSimple();
    }

    /**
     * 获取可开票的发票列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 开票主体门店
     *
     * @throws  \Exception
     * @return  array
     */
    public static function hmxStore () {
        return self::getClass()->hmxStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\ElectronicInvoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\ElectronicInvoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}