<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 */
class ProductCombo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $module 模块 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  int $occupy_value 占点设置 
     * @support  bool $is_entity 是否为实物 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  array $extend 拓展信息 
     * @support  int $photographic_num 上传照片张数 
     * @support  array $blacklist 禁用门店列表 
     * @support  string $comment 产品描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品
     *
     * @support  int $id id [ require true ]
     * @support  string $module 模块 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  int $occupy_value 占点设置 
     * @support  bool $is_entity 是否为实物 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  array $extend 拓展信息 
     * @support  int $photographic_num 上传照片张数 
     * @support  array $blacklist 禁用门店列表 
     * @support  string $comment 产品描述 
     * @support  array $sku_ids sku Id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品列表
     *
     * @support  string $name 产品名(模糊查询) 
     * @support  string $status 状态,会筛选子节点 
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductCombo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductCombo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}